function [DVine,theta]=DVineStruct(data,ind)
% creates the Dvine decomposition of the initial data based on a
% given permutation of the data columns, given in ind. 
% INPUTS:
% data: a matrix with uniform U(0,1) columns or a positive integer
% ind: a permutation of the column numbers (optional). If you do not
% provide ind=[1 2 3 ... N]
% Obviously the column number of the matrix data and the column number of
% the row vector ind, should be equal!!
% OUTPUT:
% CVine: A structure with size 1x(N-1) --> N=columns of data
% Each of the DVine pages represents a DVine tree,that contains the
% following fields:
% 1) Variables: A cell array that contains the column indexes of the data,
% for the specific tree.
% 2) CondVariables: A cell array that contains the column indexes of the 
% conditioning data set,for the specific tree.
% 3) copparam: the parameter of the copula (correlation or partial
% correlation)
% 4) data and conddata: contain the data columns with indices described in
% 1) and 2)
% EXAMPLE: in a D vine with five variables, in the second tree
% there are the following variables: 13|2, 24|3 and 35|4. 
% In the CVine(1,2) you will find:
% variables: [1 3] [2 4] [3 5]
% condvariables: [2] [3] [4]
% data: [data(:,1) data(:,3)], [data(:,2) data(:,4)], [data(:,3) data(:,5)]
% conddata: [data(:,2)], [data(:,3)], [data(:,4)]
% copparam: partial correlation of data, given conddata
%-------------------------------------------------------------------------
% Author: Vogiatzoglou Manthos, UoM, 2009
% contact: vogia@yahoo.com
%-------------------------------------------------------------------------
if isscalar(data)==1
    data=copularnd('Gaussian',gallery('randcorr',data),1000);
    N=size(data,2);
else
N=size(data,2);
end
if nargin==1
ind=linspace(1,N,N); % default indexes are: 1,2,3...,N
end
if size(data,2)~=size(ind,2)
    error('ind and data should have the same columns');
end
DVine=struct;
theta=cell(N-1,N-1);
for i=1:N-1
    DVine(1).variables{i}=[ind(i),ind(i+1)];
    DVine(1).data{i}=[data(:,ind(i)),data(:,ind(1+i))];
    XX=[data(:,ind(i)),data(:,ind(1+i))];
    DVine(1).copparam{i}=corr(XX);
    DVine(1).corr{i}=DVine(1).copparam{i}(1,2);
    theta{1,i}=DVine(1).copparam{i}(1,2);
end
for j=2:N-1 % the trees
    for i=1:N-j
    DVine(j).variables{i}=[ind(i),ind(j+i)];
    DVine(j).condvariables{i}=ind(i+1:j+i-1);
    DVine(j).data{i}=[data(:,ind(i)),data(:,ind(j+i))];
    DVine(j).conddata{i}=data(:,ind(i+1:i+j-1));
    XX=[data(:,ind(i)),data(:,ind(j+i))]; YY=data(:,ind(i+1:i+j-1));
    DVine(j).copparam{i}=partialcorr(XX,YY);
    DVine(j).parcorr{i}=DVine(j).copparam{i}(1,2);
    theta{j,i}=DVine(j).copparam{i}(1,2);
    end
end